# SmallMart Mod System (v6)

SmallMart supports **two** mod types:

## 1) Custom Mods (single file)
- Location: `data/mods/*.php`
- Enable/disable in Admin → Mods
- Metadata is read from a docblock in the file.

### Hooks API
Use `SmallMartModAPI::addHook($hookName, $callback, $priority = 10)`.

Common hooks:
- `home_before_content`
- `home_after_content`
- `item_before_purchase`
- `item_after_purchase`
- `admin_menu`
- `checkout_process` (if enabled in your build)

Your callback receives `$data` and should return `$data`.

## 2) Package Mods (recommended)
- Location: `mods/<mod-id>/`
- Required: `manifest.json`
- Required entry: `main.php` (or change `entry` in manifest)

### manifest.json example
```json
{
  "id": "hello-world",
  "name": "Hello World Banner",
  "version": "1.0.0",
  "description": "Shows a banner on the home page",
  "author": "You",
  "entry": "main.php",
  "enabled_by_default": true
}
```

### Entrypoint
SmallMart will include the entry file and then try these functions (first found wins):
- `<mod_id_sanitized>_init`
- `init`
- `<mod_id_sanitized>_initialize`

Example for `hello-world`:
- `hello_world_init()` or `init()`

## Best practices
- Never edit `index.php` for mod features. Use hooks.
- Validate and sanitize all user input.
- Use `validateCSRF()` for admin actions.
